package ns3.animator.app;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

import ns3.animator.app.globle.NsGVar;
import ns3.animator.app.view.comp.DrawingCanvas;
import ns3.animator.app.view.comp.LeftConfigurationPanel;

public class MainView extends JFrame {
  DrawingCanvas canvas;
  
  LeftConfigurationPanel configPanel;

  JLabel location;

  /**
   * draw layout
   * */
  public MainView() {
    super();
    Container container = getContentPane();

    JPanel panel = new JPanel();
    
    
    configPanel = new LeftConfigurationPanel();
    
   
    panel.setLayout(new GridLayout(1, 2));
    panel.add(new JLabel("x,y: ", JLabel.RIGHT));
    location = new JLabel("");
    panel.add(location);
    
    container.add(configPanel,BorderLayout.EAST);
    configPanel.build_initial();
    container.add(panel, BorderLayout.SOUTH);
    canvas = new DrawingCanvas(location);
    container.add(canvas);
    	//not important
    addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }
    });
    
    //add border
    panel.setBorder( BorderFactory.createTitledBorder(NsGVar.POS_INFO));
    configPanel.setBorder( BorderFactory.createTitledBorder(NsGVar.CONFIG_TITLE));
   
    canvas.setBorder( BorderFactory.createTitledBorder(NsGVar.NS3ANIMATORVIEW_TITLE));
    setSize(900,300);
    setVisible(true);
  }

  
}