/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package zombieville.engine;

import java.util.ArrayList;
import java.util.Random;
import zombieville.GUI.CenarioGUI;
import zombieville.GUI.ControleGUI;
import zombieville.GUI.Janela;

/**
 *
 * @author -Gui-
 */
public class Cenario implements TimerListener {
    
    private ArrayList<Item> itens;
    private Timer controladorFrames;
    private int posFundoMovel;
    private int posHeroi;
    public static final int PERIODO_FRAMES = 20;
    boolean partidaEncerrada;
    private CenarioGUI cenarioGui;
    private ControleGUI controleGui;
    
    public Cenario(ControleGUI controleGui) {
        
        this.controleGui = controleGui;
        
        cenarioGui = new CenarioGUI(this);
        
        itens = new ArrayList<Item>();
        
        itens.ensureCapacity(100);
        
        itens.add(new Background(0, 0, this));
        
        itens.add(new FundoMovel(0, 383, this));
        posFundoMovel = 1;
        
        itens.add(new Heroi(5, 407, this));
        posHeroi = 2;
        
        controladorFrames = new Timer(this, PERIODO_FRAMES);
        controladorFrames.start();
        
        partidaEncerrada = false;
        
    }
    
    public FundoMovel getFundoMovel() {
        
        if (getItens().get(posFundoMovel) instanceof FundoMovel) {
            return ((FundoMovel) getItens().get(posFundoMovel));
        }
        
        return null;
    }
    
    public Heroi getHeroi() {
        
        if (getItens().get(posHeroi) instanceof Heroi) {
            return ((Heroi) getItens().get(posHeroi));
        }
        
        return null;
    }
    
    @Override
    public void acaoExecutada() {
        
        if (!partidaEncerrada) {
            if (controladorFrames.getContTempo() % 5000 == 0) {
                
                criaNovoZumbi();
            }
            
            getCenarioGui().repaint();
        }
    }
    
    public void criaNovoZumbi() {
        
        Random sorteiaPosZumbi = new Random();
        
        Zumbi novoZumbi = new Zumbi(sorteiaPosZumbi.nextInt(Janela.LARGURA_PADRAO + 1), 408, this);
        novoZumbi.setPosArrayItens(itens.size());
        
        itens.add(novoZumbi);
        
    }
    
    public void perdePartida() {
        
        partidaEncerrada = true;
        controleGui.perdePartida();
    }

    /**
     * @return the ControladorFrames
     */
    public Timer getControladorFrames() {
        return controladorFrames;
    }

    /**
     * @return the Itens
     */
    public ArrayList<Item> getItens() {
        return itens;
    }

    /**
     * @return the cenarioGui
     */
    public CenarioGUI getCenarioGui() {
        return cenarioGui;
    }
}
