/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package zombieville.engine;

import java.awt.event.KeyEvent;
import zombieville.GUI.HeroiGUI;

/**
 *
 * @author -Gui-
 */
public class Heroi extends ItemMovel {

    public static final int ESQUERDA = 0;
    public static final int DIREITA = 1;
    public static final int PASSO = 3;
    public static final int TEMPO_ALTERNACAO_IMAGENS = 100;
    private int sentidoAnterior;
    private boolean fazerRotacao;
    private int vida;
    private HeroiGUI heroiGui;

    public Heroi(int x, int y, Cenario cenarioPai) {
        super(x, y, cenarioPai);

        sentidoAnterior = DIREITA;
        fazerRotacao = false;
        
        heroiGui = (HeroiGUI)getItemGui();
        
        vida = 500;

    }
    
    @Override
    public void criaItemGui() {

        setItemGui(new HeroiGUI(this));
    }


    public void alternaImagem() {

        heroiGui.alternaImagens();

        if (estaPressionado(KeyEvent.VK_LEFT) && sentidoAnterior == DIREITA || estaPressionado(KeyEvent.VK_RIGHT) && sentidoAnterior == ESQUERDA) {

            sentidoAnterior = 1 - sentidoAnterior;
            fazerRotacao = !fazerRotacao;
        }

    }
    
    @Override
    public void age(){
        
        move();
    }

    @Override
    public void move() {

        int dx = 0;
        int dy = 0;

        if (getCenarioPai().getFundoMovel().getPosDesenho().x <= -1600 && getPosDesenho().x <= 700) {


            if (estaPressionado(KeyEvent.VK_RIGHT) && !estaPressionado(KeyEvent.VK_LEFT)) {

                dx = PASSO;
            }
        }

        if (getCenarioPai().getFundoMovel().getPosDesenho().x >= -5 && getPosDesenho().x >= -10) {

            if (estaPressionado(KeyEvent.VK_LEFT) && !estaPressionado(KeyEvent.VK_RIGHT)) {

                dx = -PASSO;
            }
        }

        if (getPosDesenho().x < 350 && estaPressionado(KeyEvent.VK_RIGHT) && !estaPressionado(KeyEvent.VK_LEFT)) {

            dx = PASSO;
        }

        if (getPosDesenho().x > 350 && estaPressionado(KeyEvent.VK_LEFT) && !estaPressionado(KeyEvent.VK_RIGHT)) {

            dx = -PASSO;
        }

        setPosDesenho(getPosDesenho().x + dx, getPosDesenho().y + dy);


        if (fazerRotacao) {
            
            heroiGui.inverteHorizontalmente();

        }

        if (!(estaPressionado(KeyEvent.VK_RIGHT) && estaPressionado(KeyEvent.VK_LEFT))) {
            if (estaPressionado(KeyEvent.VK_RIGHT) || estaPressionado(KeyEvent.VK_LEFT)) {

                if (getCenarioPai().getControladorFrames().getContTempo() % TEMPO_ALTERNACAO_IMAGENS == 0) {

                    alternaImagem();
                }
                
            } else {
                
                heroiGui.estacionaImagem();
            }
        }
    }
    
    public void sofrerAtaque(int dano){
        
        vida -= dano;
        
        if(vida <= 0){
            
            morre();
        }
        
        System.out.println(vida);
    }
    
    public void morre(){
        
        getCenarioPai().perdePartida();
    }
    
    public int getVida(){
        return vida;
    }
    public void setVida(int vida){
        this.vida = vida;
    }
}
