/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package zombieville.engine;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import zombieville.GUI.ItemMovelGUI;

/**
 *
 * @author -Gui-
 */
public abstract class ItemMovel extends Item implements KeyListener {

    private int[] teclas;

    public ItemMovel(int x, int y, Cenario cenarioPai) {
        super(x, y, cenarioPai);

        teclas = new int[256];

        getCenarioPai().getCenarioGui().addKeyListener(this);
    }

    @Override
    public void criaItemGui() {

        setItemGui(new ItemMovelGUI(this));
    }

    public abstract void age();
    public abstract void move();

    @Override
    public void keyPressed(KeyEvent evento) {

        teclas[evento.getKeyCode() & 0xff] = 1;

    }

    @Override
    public void keyReleased(KeyEvent evento) {

        teclas[evento.getKeyCode() & 0xff] = 0;
    }

    @Override
    public void keyTyped(KeyEvent evento) {
    }

    public boolean estaPressionado(int keyCode) {

        return (teclas[keyCode & 0xff] == 1);
    }
}
