/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package zombieville.engine;

import java.awt.event.KeyEvent;
import zombieville.GUI.ZumbiGUI;

/**
 *
 * @author -Gui-
 */
public class Zumbi extends ItemMovel {

    public static final int TEMPO_ALTERNACAO_IMAGENS = 100;
    public static final int PASSO = 2;
    public static final int ESQUERDA = 0;
    public static final int DIREITA = 1;
    public static final int DANO_CAUSADO = 1;
    public int sentido;
    private int posArrayItens;
    private ZumbiGUI zumbiGui;

    public Zumbi(int x, int y, Cenario cenarioPai) {
        super(x, y, cenarioPai);

        if (x > getCenarioPai().getHeroi().getPosDesenho().x) {

            sentido = ESQUERDA;
        } else {

            sentido = DIREITA;
        }

        zumbiGui = (ZumbiGUI) getItemGui();

    }

    @Override
    public void criaItemGui() {

        setItemGui(new ZumbiGUI(this));
    }

    public void alternaImagem() {

        zumbiGui.alternaImagens();

        if (sentido == ESQUERDA && getPosDesenho().x < getCenarioPai().getHeroi().getPosDesenho().x
                || sentido == DIREITA && getPosDesenho().x > getCenarioPai().getHeroi().getPosDesenho().x) {

            sentido = 1 - sentido;
        }
    }

    @Override
    public void age() {

        move();

        if (sentido == DIREITA && getPosDesenho().x > getCenarioPai().getHeroi().getPosDesenho().x - 60
                || sentido == ESQUERDA && getPosDesenho().x < getCenarioPai().getHeroi().getPosDesenho().x + 60) {

            atacaHeroi();
        }

    }

    @Override
    public void move() {

        int dx = 0;
        int dy = 0;

        if (getPosDesenho().x < getCenarioPai().getHeroi().getPosDesenho().x - 30) {

            dx = PASSO;
        }

        if (getPosDesenho().x > getCenarioPai().getHeroi().getPosDesenho().x + 50) {

            dx = -PASSO;
        }


        if (!(estaPressionado(KeyEvent.VK_RIGHT) && estaPressionado(KeyEvent.VK_LEFT))) {


            if (estaPressionado(KeyEvent.VK_RIGHT)) {

                if (getCenarioPai().getHeroi().getPosDesenho().x == 350) {

                    dx -= Heroi.PASSO;
                }
            }

            if (estaPressionado(KeyEvent.VK_LEFT)) {

                if (getCenarioPai().getHeroi().getPosDesenho().x == 350) {

                    dx += Heroi.PASSO;
                }
            }
        }

        setPosDesenho(getPosDesenho().x + dx, getPosDesenho().y + dy);

        if (getCenarioPai().getControladorFrames().getContTempo() % TEMPO_ALTERNACAO_IMAGENS == 0) {

            alternaImagem();
        }

        if (sentido == ESQUERDA) {

            zumbiGui.inverteHorizontalmente();
        }

    }

    public void atacaHeroi() {

        if (getCenarioPai().getHeroi().getVida() > 0) {
            getCenarioPai().getHeroi().sofrerAtaque(DANO_CAUSADO);
        }
    }

    /**
     * @param posArrayItens the posArrayItens to set
     */
    public void setPosArrayItens(int posArrayItens) {
        this.posArrayItens = posArrayItens;
    }
}
