package common;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;

import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class SimpleMessageConverter implements MessageConverter {

	@Override
	public Object fromMessage(Message message) throws JMSException,
			MessageConversionException {
		if(!(message instanceof TextMessage)) {
			throw new MessageConversionException("Message is not an instance of TextMessage");
		}
		TextMessage textMessage = (TextMessage) message;
		
		SimpleMessage msg = new SimpleMessage(textMessage.getText());
		return msg;
	}

	@Override
	public Message toMessage(Object obj, Session session) throws JMSException,
			MessageConversionException {
		if(!(obj instanceof SimpleMessage)) {
			throw new MessageConversionException("Object is not an instance of SimpleMessage");
		}
		SimpleMessage msg = (SimpleMessage) obj;
		
		TextMessage message = session.createTextMessage();
		message.setText(msg.getText());
		return message;
	}

}
