package com.google.code.ccr4j.extensions;

import java.util.List;

import com.google.code.ccr4j.ActorType;
import com.google.code.ccr4j.IDType;

import org.apache.xmlbeans.XmlObject;

/**
 * Static helpers called by XMLBeans to implement the IdentificationHelper extension interface
 * @see IdentificationHelper
 * @author aeagle
 *
 */
public class IdentificationHelperImpl { // sort of implements IdentificationHelper {

    public static String getChartNumber(XmlObject xmlObject) {
        checkType(xmlObject);
        return getID((ActorType)xmlObject, IdentificationHelper.CHART_NUMBER_KEYS);
    }
    
    public static void setChartNumber(XmlObject xmlObject, String chartNumber) {
        checkType(xmlObject);
        setID((ActorType)xmlObject, chartNumber, IdentificationHelper.CHART_NUMBER);
    }
    
    public static void setSocialSecurityNumber(XmlObject xmlObject, String ssn) {
        checkType(xmlObject);
        setID((ActorType)xmlObject, ssn, IdentificationHelper.SOCIAL_SECURITY_NUMBER);
    }

    public static String getSocialSecurityNumber(XmlObject xmlObject) {
        checkType(xmlObject);
        return getID((ActorType)xmlObject, IdentificationHelper.SOCIAL_SECURITY_NUMBER_KEYS);
    }
    
    private static IDType findType(ActorType actor, String type) {
        return findType(actor.getIDsList(), type);
    }

    private static IDType findType(List<IDType> idsList, String type) {
        for (IDType idType : idsList) {
            if (idType.isSetType()) {
                if (type.equals(idType.getType().getText())) {
                    return idType;
                }
            }
        }
        return null;
    }
    
    // Look through the candidate names, return the entry that matches the first name in the list
    private static String getID(ActorType actor, List<String> names) {
        for (String name : names) {
            IDType idType = findType(actor, name);
            if (idType != null) {
                return idType.getID();
            }
        }
        return null;
    }

    private static void setID(String value, String type, IDType idType, List<IDType> idsList) {
        if (idType == null) {
            // Need to add the ID type for it
            idType = IDType.Factory.newInstance();
            idType.addNewType().setText(type);
            idType.setID(value);
            idsList.add(idType);
        } else {
            idType.setID(value);
        }
    }
    
    /**
     * Set the value as an ID in the actor, with the given type.
     * @param actor
     * @param value
     * @param type
     */
    private static void setID(ActorType actor, String value, String type) {
        IDType idType = findType(actor, type);
        List<IDType> idsList = actor.getIDsList();
        setID(value, type, idType, idsList);        
    }
    private static void checkType(XmlObject xmlObject) {
        if (!(xmlObject instanceof ActorType)) {
            throw new IllegalArgumentException("Can only handle ActorType, not " + xmlObject.getClass().getName());
        }
    }
}
