package oh.how.easy.fck;

import oh.how.easy.fck.constants.FckEditorConstants;
import net.fckeditor.connector.Tapestry5InterceptFckActivityFilter;
import oh.how.easy.fck.services.FckEditorService;
import oh.how.easy.fck.services.FckEditorServiceImpl;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.LibraryMapping;

/**
 *
 * @author Ville Virtanen
 */
public class FckEditorModule {

    public void contributeHttpServletRequestHandler(OrderedConfiguration<HttpServletRequestFilter> configuration, @Autobuild Tapestry5InterceptFckActivityFilter fckActivityFilter)
    {
        configuration.add("FckEditorInterceptFilter", fckActivityFilter, "before:*");
    }

    public static void contributeComponentClassResolver(Configuration<LibraryMapping> configuration)
    {
        configuration.add(new LibraryMapping("easyfck", "oh.how.easy.fck"));
    }

    public static void contributeClasspathAssetAliasManager(MappedConfiguration<String, String> configuration, @Inject @Symbol(FckEditorConstants.EDITOR_CONTEXT) String location)
    {
        configuration.add(location, "oh/how/easy/fck/js");
    }

    public static void bind(ServiceBinder binder)
    {
        binder.bind(FckEditorService.class, FckEditorServiceImpl.class);
    }

    /**
     * Contributes factory defaults that may be overridden.
     */
    public static void contributeFactoryDefaults(MappedConfiguration<String, String> configuration, ApplicationGlobals applicationGlobals)
    {
        //Try to use the getContextPath method that was introduced in servlet spec 2.5
        try {
            String context = applicationGlobals.getServletContext().getContextPath();
            configuration.add(FckEditorConstants.APPLICATION_CONTEXT, context + "/");
        } catch (Throwable throwable) {
            configuration.add(FckEditorConstants.APPLICATION_CONTEXT, "/");
        }

        configuration.add(FckEditorConstants.EDITOR_CONTEXT, "easyfck");
    }

}
