package oh.how.easy.fck.connector;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import net.fckeditor.connector.Connector;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.ReadException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.connector.impl.LocalConnector;
import net.fckeditor.handlers.ResourceType;
import oh.how.easy.fck.services.FckEditorConnector;
import oh.how.easy.fck.util.LegacyT5ServiceHelper;

/**
 * This implementation forwards the requests to default implementation 
 * (@linkplain LocalConnector} from java.fckeditor.net) or uses the custom one
 * if developer has created and bind one. (The custom implementation must
 * implement interface {@linkplain FckEditorConnector}.)
 * @author Ville
 */
public class FckEditorConnectorBridge implements Connector {

    private LocalConnector defaultImplementation;
    private FckEditorConnector editorConnector;

    @Override
    public void createFolder(ResourceType type, String currentFolder, String newFolder) throws InvalidCurrentFolderException, InvalidNewFolderNameException, FolderAlreadyExistsException, WriteException {
        if(editorConnector != null) {
            editorConnector.createFolder(type, currentFolder, newFolder);
        } else {
            defaultImplementation.createFolder(type, currentFolder, newFolder);
        }
    }

    @Override
    public String fileUpload(ResourceType type, String currentFolder, String fileName, InputStream inputStream) throws InvalidCurrentFolderException, WriteException {
        if(editorConnector != null) {
            return editorConnector.fileUpload(type, currentFolder, fileName, inputStream);
        } else {
            return defaultImplementation.fileUpload(type, currentFolder, fileName, inputStream);
        }
    }

    @Override
    public List<Map<String, Object>> getFiles(ResourceType type, String currentFolder) throws InvalidCurrentFolderException, ReadException {
        if(editorConnector != null) {
            return editorConnector.getFiles(type, currentFolder);
        } else {
            return defaultImplementation.getFiles(type, currentFolder);
        }
    }

    @Override
    public List<String> getFolders(ResourceType type, String currentFolder) throws InvalidCurrentFolderException, ReadException {
        if(editorConnector != null) {
            return editorConnector.getFolders(type, currentFolder);
        } else {
            return defaultImplementation.getFolders(type, currentFolder);
        }
    }

    @Override
    public void init(ServletContext servletContext) throws Exception {
        defaultImplementation = new LocalConnector();
        defaultImplementation.init(servletContext);
        editorConnector = LegacyT5ServiceHelper.getService(FckEditorConnector.class, servletContext);
    }

}