package oh.how.easy.fck.services;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.fckeditor.connector.exception.FolderAlreadyExistsException;
import net.fckeditor.connector.exception.InvalidCurrentFolderException;
import net.fckeditor.connector.exception.InvalidNewFolderNameException;
import net.fckeditor.connector.exception.ReadException;
import net.fckeditor.connector.exception.WriteException;
import net.fckeditor.handlers.ResourceType;

/**
 * To implement a custom connector implementation one must implement this interface according to the specs.
 * @author Ville
 */
public interface FckEditorConnector {

    /**
	 * Returns a list of file attributes from the backend. Use the pre-defined
	 * keys ({@value #KEY_NAME}, {@value #KEY_SIZE}) to put file attributes into
	 * the file map. The file length can be any instance of {@link Number}, its
	 * long value will be taken as the final value.
	 *
	 * @param type
	 *            the current resource type
	 * @param currentFolder
	 *            the current folder
	 * @return a list of file attributes
	 * @throws InvalidCurrentFolderException
	 *             if the current folder name is invalid or does not exist
	 *             within the underlying backend
	 * @throws ReadException
	 *             if the file attributes could not be read due to some reason
	 */
	public List<Map<String, Object>> getFiles(final ResourceType type,
			final String currentFolder) throws InvalidCurrentFolderException,
			ReadException;

	/**
	 * Returns a list of folders from the backend.
	 *
	 * @param type
	 *            the current resource type
	 * @param currentFolder
	 *            the current folder
	 * @return a list of folder names
	 * @throws InvalidCurrentFolderException
	 *             if the current folder name is invalid or does not exist
	 *             within the underlying backend
	 * @throws ReadException
	 *             if the folder names could not be read due to some reason
	 */
	public List<String> getFolders(final ResourceType type,
			final String currentFolder) throws InvalidCurrentFolderException,
			ReadException;

	/**
	 * Creates a new folder on the backend.
	 *
	 * @param type
	 *            the current resource type
	 * @param currentFolder
	 *            the current folder
	 * @param newFolder
	 *            name of the new folder
	 * @throws InvalidCurrentFolderException
	 *             if the current folder name is invalid or does not exist
	 *             within the underlying backend
	 * @throws InvalidNewFolderNameException
	 *             if the new folder name is invalid due to some reason
	 * @throws FolderAlreadyExistsException
	 *             if the new folder already exists
	 * @throws WriteException
	 *             if the new folder could not be created due to some reason
	 */
	public void createFolder(final ResourceType type,
			final String currentFolder, final String newFolder)
			throws InvalidCurrentFolderException,
			InvalidNewFolderNameException, FolderAlreadyExistsException,
			WriteException;

	/**
	 * Uploads a new file on to the backend. You are not allowed to overwrite
	 * already existing files, rename the new file and return the new filename.
	 *
	 * @param type
	 *            the current resource type
	 * @param currentFolder
	 *            the current folder
	 * @param fileName
	 *            the name of the new file
	 * @param inputStream
	 *            input stream of the new file
	 * @return the (eventually renamed) name of the uploaded file
	 * @throws InvalidCurrentFolderException
	 *             if the current folder name is invalid or does not exist
	 *             within the underlying backend
	 * @throws WriteException
	 *             if the new file could not be created due to some reason
	 */
	public String fileUpload(final ResourceType type,
			final String currentFolder, final String fileName,
			final InputStream inputStream)
			throws InvalidCurrentFolderException, WriteException;

}
