package oh.how.easy.fck.services;

/**
 * This interface represents the service that must be implemented when using file uploads. <br />
 * This service tells Fck editor where to save files, and where those files can be accessed through http(s) protocol (web).
 * @author Ville Virtanen
 */
public interface FckEditorPathService {

    /**
     * Return the full path where to save the files in the server. <br />
     * This path must contain the trailing directory separator. <br />
     * This can be for an example C:\www\staticcontent\.
     * @return
     */
    public String getServerPathForFiles();

    /**
     * Returns the full or relative URI to the uploaded files. <br />
     * This part must contain the trailing slash. <br />
     * For an example this can be /staticcontent/ and it must point TO THE SAME PLACE as the path that can be accessed from getServerPathForFiles().
     * The files are simply shared to web via this url.
     * @return
     */
    public String getClientURLStartForFiles();

}
