package problems;

import java.util.ArrayList;
import java.util.List;

import utils.Utils;

//TODO sneller
public class Problem205 {
	public static void main(String[] args) {
		List<Integer> pResults = rollPyramid();
		List<Integer> cResults = rollCube();

		long total = pResults.size() * (long)cResults.size();
		System.out.println("Playing " + total + " games");
		
		long pWin = 0;
		long cWin = 0;
		int draw = 0;
		int count = 0;
		for (int pResult : pResults) {
			if (++count % 10000 == 0) {
				Utils.printProgress(count, pResults.size());
			}
			for (int cResult : cResults) {  // 12230590464 iterations
				if (pResult==cResult) {
					draw++;
				}
				else if (cResult > pResult) {
					cWin++;
				}
				else {
					pWin++;
				}
			}
		}
		
		System.out.printf("Colin wins %d, Pete wins %d, %d draws%n", cWin, pWin, draw);
		System.out.printf("Probability of Pete winning is %.7f%n", pWin / (double)(total));
	}
	
	private static List<Integer> rollCube() {
		int sides = 6;
		List<Integer> list = new ArrayList<Integer>();
		
		for (int d1 = 1; d1 <= sides; d1++) {
			for (int d2 = 1; d2 <= sides; d2++) {
				for (int d3 = 1; d3 <= sides; d3++) {
					for (int d4 = 1; d4 <= sides; d4++) {
						for (int d5 = 1; d5 <= sides; d5++) {
							for (int d6 = 1; d6 <= sides; d6++) {
								list.add(d1+d2+d3+d4+d5+d6);
							}
						}
					}
				}
			}
		}
		
		return list;
	}
	
	private static List<Integer> rollPyramid() {
		int sides = 4;
		List<Integer> list = new ArrayList<Integer>();
		
		for (int d1 = 1; d1 <= sides; d1++) {
			for (int d2 = 1; d2 <= sides; d2++) {
				for (int d3 = 1; d3 <= sides; d3++) {
					for (int d4 = 1; d4 <= sides; d4++) {
						for (int d5 = 1; d5 <= sides; d5++) {
							for (int d6 = 1; d6 <= sides; d6++) {
								for (int d7 = 1; d7 <= sides; d7++) {
									for (int d8 = 1; d8 <= sides; d8++) {
										for (int d9 = 1; d9 <= sides; d9++) {
											list.add(d1+d2+d3+d4+d5+d6+d7+d8+d9);
										}
									}
								}
							}
						}
					}
				}
			}
		}
		
		return list;
	}
}
