package problems;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import utils.Utils;

@SuppressWarnings("unused")
public class Problem99 extends Problem<Integer> {
	public static void main(String[] args) {
		Problem99 problem99 = new Problem99();
		problem99.runTimed();
		problem99.printResult();
	}
	
	private final List<Pair> pairs = new ArrayList<Pair>();
	private final int[] powersOfTwo = {1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 1048576};

	@Override
	public void init() {
		Scanner scanner = Utils.getScannerForFile("base_exp.txt");
		while(scanner.hasNext()) {
			pairs.add(new Pair(scanner.nextLine()));
		}
	}
	
	@Override
	public void run() {
	}

	private void second() {
		//Run time near 28 hr
		long startTime = System.currentTimeMillis();
		BigInteger max = BigInteger.ZERO;
		int line = 0;
		int currentLine = 0;
		for (Pair p : pairs) {
			int exp = p.b;
			
			BigInteger value = BigInteger.valueOf(p.a);

			List<BigInteger> list = new ArrayList<BigInteger>();
			list.add(BigInteger.ONE);
			list.add(value);
			while (powersOfTwo[list.size()] < exp) {
				value = value.multiply(value);
				list.add(value);
			}
//			System.out.printf("Constructed list of size %d for %d^%d%n", list.size(), p.a, p.b);
			
			BigInteger product = BigInteger.ONE;
			for (int i = list.size()-1; i >= 0; i--) {
				if (exp >= powersOfTwo[i]) {
					product = list.get(i).multiply(product);
//					System.out.printf("Adding %s, exp (%d) -= %d%n", product, exp, powersOfTwo[list.size()]);
					exp -= powersOfTwo[i];
				}
			}
			if (exp != 0) {
				throw new IllegalStateException("Rest: " + exp);
			}
			if (product.compareTo(max) > 0) {
				max = product;
				line = currentLine;
			}
			currentLine++;
			Utils.printProgress(currentLine, 1000, startTime);
		}
		setResult(line);
	}

	private void first() {
		long startTime = System.currentTimeMillis();
		BigInteger max = BigInteger.ZERO;
		int line = -1;
		int i = 1;
		for (Pair p : pairs) {
			//Run time near inf.
			final BigInteger value = BigInteger.valueOf(p.a).pow(p.b);
			if (max.compareTo(value) < 0) {
				line = i;
				max = value;
			}
			i++;
			Utils.printProgress(i, 1000, startTime);
		}
		setResult(line);
	}

	private static class Pair {
		private final int a;
		private final int b;

		public Pair(String line) {
			String[] parts = line.split(",");
			this.a = Integer.parseInt(parts[0]);
			this.b = Integer.parseInt(parts[1]);
		}
	}
}
