package problems.runner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ProblemRunner {
	private static final int NEXT_PROBLEM = 253;

	public static void main(String[] args) {
		PrintStream originalOut = System.out;
		
		System.setOut(new PrintStream(new OutputStream() {
			@Override
			public void write(int b) throws IOException {
			}}));
		System.setErr(new PrintStream(new OutputStream() {
			@Override
			public void write(int b) throws IOException {
				throw new IllegalStateException("no!");
			}}));
		
		
		List<ProblemThread> list = new ArrayList<ProblemThread>();
		for (int i = 1; i < NEXT_PROBLEM; i++) {
			try {
				final ProblemThread t = new ProblemThread(i, originalOut);
				list.add(t);
				t.start();
			}
			catch (ClassNotFoundException e) {
			} 
		}
		try {
			Thread.sleep(10000);
		} 
		catch (InterruptedException e) {
		}
		for (ProblemThread t : list) {
			if (t.isAlive()) {
				originalOut.println("Slacker: " + t);
			}
		}
	}
}
