package problems.solved;

import java.util.regex.Pattern;

import utils.Utils;

public class Problem206 {
	private static final long LOWER = (long) Math.sqrt(10203040506070809L);
	private static final long UPPER = (long) Math.sqrt(19293949596979899L);
	
	public static void main(String[] args) {
		Pattern pattern = Pattern.compile("1\\d2\\d3\\d4\\d5\\d6\\d7\\d8\\d9");

		System.out.println(LOWER + " to " + UPPER);
		//start at 101010103
		for (long i = LOWER+2; i <= UPPER; i += (i % 10 == 3 ? 4 : 6)) {
			if (i % 5000000 == 3) {
				Utils.printProgress(i - LOWER, UPPER - LOWER);
			}
			final String number = Long.toString(i*i);
			if (number.length() == 17 && pattern.matcher(number).matches()) {
				System.out.println(i + "0^2 = " + number + "00");
			}
		}
	}
}
