package problems.solved;

public class Problem33 {
    public static void main(String[] args) {
        int nTot = 1;
        int dTot = 1;
        
        for (int numerator = 10; numerator < 100; numerator++) {
            for (int denominator = numerator + 1; denominator < 100; denominator++) {
                if (accept(numerator, denominator)) {
                    nTot *= numerator;
                    dTot *= denominator;
                }
            }
        }
        final double frac = ((double)nTot)/dTot;
		System.out.printf("%d/%d=%.20f; divisor = %d%n", nTot, dTot, frac, (int)(1/frac)); // 0,01 => 100
    }

    private static boolean accept(int num, int den) {
        String numerator = num+"";
        String denominator = den+"";
        for (int i = 1; i <= 9; i++) {
            int nIndex = numerator.indexOf(i+48);
            if (nIndex != -1) {
                int dIndex = denominator.indexOf(i+48);
                if (dIndex != -1) {
                    int nRest = nIndex == 0 ? numerator.charAt(1)-48 : numerator.charAt(0)-48;
                    int dRest = dIndex == 0 ? denominator.charAt(1)-48 : denominator.charAt(0)-48;
                    if (nRest == 0 || dRest == 0) {
                        return false;
                    }
                    return equal(num, den, nRest, dRest);
                }
            }
        }
        return false;
    }

    private static boolean equal(int num, int den, int nRest, int dRest) {
        return Math.abs((((double)num)/den)-(((double)nRest)/dRest)) < 0.00001d;
    }
}
