package problems.solved;

import problems.Problem;
import utils.Utils;

public class Problem36 extends Problem<Integer> {
	private static final int TARGET = 1000000;

	public static void main(String[] args) {
		Problem36 problem36 = new Problem36();
		problem36.runTimed();
		problem36.printResult();
	}
	
	@Override
	public void run() {
		int sum = 0;
		for (int i = 1; i < TARGET; i++) {
			if (applies(i)) {
				System.out.println("Adding " + i);
				sum += i;
			}
		}
		setResult(sum);
	}

	private boolean applies(int i) {
		final String string = Integer.toString(i, 2);
		return !string.startsWith("0") && Utils.isPalindrome(i) && Utils.isPalindrome(string);
	}

}
