package problems.solved;

import problems.Problem;
import utils.Utils;

public class Problem38 extends Problem<Integer> {

	public static void main(String[] args) {
		Problem38 problem38 = new Problem38();
		problem38.runTimed();
		problem38.printResult();
	}
	
	@Override
	public void run() {
		int largest = 0;

		for (int mult = 2; mult < 10; mult++) {
			for (int i = 10; i < 50000; i++) {
				String string = build(i, mult);
				if (string.length() != 9) {
					continue;
				}
				int num = Integer.parseInt(string);
				if (num > largest && Utils.isPandigital(string, 9)) {
					largest = num;
				}
			}
		}
		
		setResult(largest);
	}

	private String build(int n, int mult) {
		String result = "";
		for (int i = 1; i <= mult; i++) {
			result += n * i;
		}
		return result;
	}
}
