package problems.solved;

import java.util.HashSet;
import java.util.Set;

import problems.Problem;

public class Problem39 extends Problem<Integer> {
	private static final int TARGET = 1000;
	
	public static void main(String[] args) {
		Problem39 problem39 = new Problem39();
		problem39.runTimed();
		problem39.printResult();
	}

	@Override
	public void run() {
		int max = 0;
		int answer = 0;
		for (int p = 0; p < TARGET; p++) {
			Set<Set<Integer>> result = new HashSet<Set<Integer>>();
			
			for (int i = p/2; i > 1; i--) { //longest side
				for (int j = 1; j < p-i-1; j++) {
					int k = p - i - j;
					assert i + j + k == p;
					if (isIntegralTriangle(i, j, k)) {
						result.add(set(i,j,k));
					}
				}
			}
			if (result.size() > max) {
				max = result.size();
				answer = p;
			}
		}
		setResult(answer);
	}

	private Set<Integer> set(int i, int j, int k) {
		HashSet<Integer> set = new HashSet<Integer>();
		set.add(i);
		set.add(j);
		set.add(k);
		assert set.size() == 3;
		return set;
	}

	private boolean isIntegralTriangle(int i, int j, int k) {
		final int i2 = i*i;
		final int j2 = j*j;
		final int k2 = k*k;

		return j2 + k2 == i2;
	}
}
