package problems.solved;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;

import problems.Problem;

import utils.Utils;

public class Problem42 extends Problem<Integer> {
	private static final List<Integer> triangles = Arrays.asList(1, 3, 6, 10, 15, 21, 28, 36, 45, 55, 66, 78, 91, 105, 120, 136, 153, 171, 190);

	private final Set<String> words = new HashSet<String>();

	public static void main(String[] args) {
		Problem42 problem42 = new Problem42();
		problem42.runTimed();
		problem42.printResult();
	}

	@Override
	public void init() {
		Scanner scanner = Utils.getScannerForFile("words.txt");
		scanner.useDelimiter(",");
		while (scanner.hasNext()) {
			String quotedWord = scanner.next();
			words.add(quotedWord.substring(1, quotedWord.length() - 1));
		}
	}
	
	@Override
	public void run() {
		int result = 0;
		
		for (String word : words) {
			if (triangles.contains(value(word))) {
				result++;
			}
		}
		
		setResult(result); // 162
	}

	private int value(String word) {
		int value = 0;
		for (char c : Utils.charIterable(word)) {
			final int n = c - 64;
			value += n;
		}
		return value;
	}
}
