package problems.solved;

import java.util.HashSet;

import problems.Problem;

import utils.Utils;

public class Problem47 extends Problem<Integer> {
	private static final int NUMBERS = 4;
	
	public static void main(String[] args) {
		Problem47 problem47 = new Problem47();
		problem47.runTimed();
		problem47.printResult();
	}
	
	@Override
	public void run() {
		for (int i = 10; ; i++) {
			if (check(i)) {
				setResult(i); // 134043
				return;
			}
		}
	}

	private boolean check(int base) {
		for (int i = base; i < base + NUMBERS; i++) {
			if (primeFactors(i) != NUMBERS) {
				return false;
			}
		}
		return true;
	}

	private int primeFactors(int i) {
		return new HashSet<Long>(Utils.primeFactors(i)).size();
	}
}
