package problems.solved;

import java.util.HashSet;
import java.util.List;

import problems.Problem;

import utils.Utils;

public class Problem49 extends Problem<Long> {
	private static final int INCREMENT = 3330;
	List<Integer> sieve = Utils.sieve(10000);
	
	public static void main(String[] args) {
		Problem49 problem49 = new Problem49();
		problem49.runTimed();
		problem49.printResult();
	}

	@Override
	public void run() {
		for (int n1 = 1489; n1 < 3340; n1+=2) {
			final int n2 = n1 + INCREMENT;
			final int n3 = n2 + INCREMENT;
			if (sieve.contains(n1) && sieve.contains(n2) && sieve.contains(n3) && isPermutation(n1, n2, n3)) {
				setResult(Long.parseLong("" + n1 + n2 + n3)); // 296962999629
				return;
			}
		}
	}

	private boolean isPermutation(int n, int n2, int n3) {
		final HashSet<String> set = new HashSet<String>();
		
		Utils.permutate("", (""+n).toCharArray(), set);
		
		return set.contains(""+n2) && set.contains(""+n3);
	}
}
