package problems.solved;

import java.util.HashSet;
import java.util.Set;

import problems.Problem;

import utils.Utils;

public class Problem52 extends Problem<Long> {

	public static void main(String[] args) {
		Problem52 problem52 = new Problem52();
		problem52.runTimed();
		problem52.printResult();
	}
	
	@Override
	public void run() {
		long next = 100000L;
		for (long i = 10000L; ; i++) {
			if (Long.toString(i).startsWith("1667")) {
				i = next;
				next *= 10L;
				System.out.println("Next: " + i);
			}
			if (allDigitsSame(i, i*2, i*3, i*4, i*5, i*6)) {
				setResult(i); // 142857
				return;
			}
		}
	}

	private boolean allDigitsSame(long a, long... rest) {
		final String string = Long.toString(a);
		if (string.length() != Long.toString(rest[rest.length-1]).length()) {
			return false;
		}

		Set<String> set = new HashSet<String>();
		Utils.permutate("", string.toCharArray(), set);
		
		for (long l : rest) {
			if (!set.contains(l+"")) {
				return false;
			}
		}
		return true;
	}
}
