package problems.solved;

import java.math.BigInteger;

import utils.Utils;

public class Problem55 {
	private static final int TARGET = 10000;

	public static void main(String[] args) {
		int count = 0;
		for (int number = 1; number < TARGET; number++) {
			if (isLychel(BigInteger.valueOf(number))) {
				count++;
			}
		}
		System.out.printf("%d numbers under %d are probably Lychrel", count, TARGET);
	}

	private static boolean isLychel(BigInteger number) {
		for (int count = 0; count < 50; count++) {
			number = number.add(reverse(number));
			if (Utils.isPalindrome(number.toString())) {
				return false;
			}
		}
		return true;
	}

	private static BigInteger reverse(BigInteger number) {
		StringBuilder reverse = new StringBuilder();
		for (char c : number.toString().toCharArray()) {
			reverse = reverse.insert(0, c);
		}
		return new BigInteger(reverse.toString());
	}
}
