package org.exhibitj.automation.actions;

import java.awt.Point;

import org.eclipse.swt.widgets.Control;

public class FetchRightSideOf implements PointTracker {

	private final Control findRightOf;

	public FetchRightSideOf(Control control) {
		this.findRightOf = control;
	}

	@Override
	public Point fetchPoint() {
		Control control = findRightOf;
		int x = control.getBounds().width - 3;
		int y = control.getBounds().height / 2 + 20;
		while (control != null) {
			x += control.getBounds().x;
			y += control.getBounds().y;
			control = control.getParent();
		}
		return new Point(x, y);
	}

}
