package org.exhibitj.automation.actions;

import java.awt.Point;

import org.exhibitj.automation.Action;
import org.exhibitj.automation.Agent;


public class MoveToAction implements Action {
	private final PointTracker tracker;

	public MoveToAction(PointTracker location) {
		this.tracker = location;
	}

	@Override
	public void perform(Agent agent) {
		Point point = tracker.fetchPoint();
		agent.moveToLocation(point.x, point.y);
	}

}
