package org.exhibitj.operators;

import org.exhibitj.defect.Defect;
import org.exhibitj.operators.matchers.Matcher;


public abstract class AbstractTextOperator extends ControlOperator {

	public AbstractTextOperator(ShellOperator shell) {
		super(shell);
	}

	public void hasText(Matcher<String> expected) {
		String actual = SWTDisplayThread.fetch(textDisplayFetcher());
		if (!expected.isMatch(actual)) {
			throw new MismatchTextDefect("\nText mismatch: \n\t" + expected.describe(actual));
		}
	}
	
	protected abstract FetchingRunnable<String> textDisplayFetcher();
	
	@SuppressWarnings("serial")
	class MismatchTextDefect extends Defect {
		MismatchTextDefect(String explanation) {
			super(explanation);
		}
	}
}
