package org.exhibitj.operators;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.exhibitj.operators.matchers.Matcher;

public class LabelOperator extends AbstractTextOperator {
	private final Label label;
	
	public LabelOperator(ShellOperator shell, Matcher<Label>...matchers) {
		super(shell);
		label = shell.findWidget(Label.class, matchers);
	}

	@Override
	protected Control getControl() {
		return label;
	}

	@Override
	protected FetchingRunnable<String> textDisplayFetcher() {
		return new FetchingRunnable<String>() {
			@Override
			public String fetchValue() {
				return label.getText();
			}
		};
	}
}
