package org.exhibitj.operators;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.exhibitj.operators.matchers.Matcher;

public class TextOperator extends AbstractTextOperator {
	private Text text;

	public TextOperator(ShellOperator shell, Matcher<Text>... matchers) {
		super(shell);
		text = shell.findWidget(Text.class, matchers);
	}

	@Override
	protected Control getControl() {
		return text;
	}

	public void enterText(String string) {
		checkIsVisible();

		askAgentTo(typeAsSequence(string));

		shell.waitForEvents();
	}

	@Override
	protected FetchingRunnable<String> textDisplayFetcher() {
		return new FetchingRunnable<String>() {
			@Override
			public String fetchValue() {
				LOG.info("text in text field");
				return text.getText();
			}
		};
	}
}
