package org.exhibitj.operators.matchers;


public class EqualityMatcher<T> implements Matcher<T> {

	private final T expected;

	public EqualityMatcher(T expected) {
		this.expected = expected;
	}
	
	@Override
	public boolean isMatch(T actual) {
		return actual.equals(expected);
	}

	public String describe(T actual) {
		return "expected to be [" + expected + "], but was [" + actual + "].";
	}
}
