package org.exhibitj.operators;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.List;
import org.exhibitj.operators.matchers.Matcher;
import org.exhibitj.operators.matchers.NamedControlMatcher;
import org.junit.Test;

public class TestListOperator extends AbstractControlOperator<List, ListOperator> {
	private static final String UNIQUE_WIDGET_NAME = "myList";
	
	@Override
	protected Class<List> widgetType() {
		return List.class;
	}

	@SuppressWarnings("unchecked")
	@Override
	protected ListOperator createOperator() {
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.setData(NamedControlMatcher.DEFAULT_NAME, UNIQUE_WIDGET_NAME);
				control.pack();
			}
		});
		return new ListOperator(shell, new NamedControlMatcher<List>(UNIQUE_WIDGET_NAME));
	}

	@Test
	public void userSelectsFromList() throws Exception {
		ListOperator operator = createOperator();
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.add("apple");
				control.add("banana");
				control.add("grape");
				control.add("orange");
				control.add("strawberry");
				control.add("cherry");
				control.add("kiwi");
				control.add("passion fruit");
				control.add("black berry");
				for (int i = 1; i < 21; i++) {
					control.add("filler " + i);
				}
				control.add("blue berry");
				control.setSize(100, 300);
				control.getParent().pack();
			}
		});
		operator.select("kiwi");
		operator.hasSelection(containingItem("kiwi"));
		
		operator.select("apple");
		operator.hasSelection(containingItem("apple"));
		
		operator.select("blue berry");
		operator.hasSelection(containingItem("blue berry"));
	}
	
	@Test
	public void selectionWhenSmallFontSizeIsUsed() throws Exception {
		ListOperator operator = createOperator();
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				Font font = control.getFont();
				Font smallFont = new Font(font.getDevice(), "bobo", 6, SWT.ITALIC);
				control.setFont(smallFont);
				control.add("apple");
				control.add("banana");
				control.add("grape");
				control.add("orange");
				control.add("strawberry");
				control.add("cherry");
				control.add("kiwi");
				control.add("passion fruit");
				control.add("black berry");
				for (int i = 1; i < 21; i++) {
					control.add("filler " + i);
				}
				control.add("blue berry");
				control.setSize(100, 300);
				control.getParent().pack();
			}
		});
		operator.select("kiwi");
		operator.hasSelection(containingItem("kiwi"));
		
		operator.select("apple");
		operator.hasSelection(containingItem("apple"));
		
		operator.select("blue berry");
		operator.hasSelection(containingItem("blue berry"));
	}

	private Matcher<String[]> containingItem(final String item) {
		return new Matcher<String[]>() {
			@Override
			public boolean isMatch(String[] values) {
				for (String each : values) {
					if (each.equals(item)) {
						return true;
					}
				}
				return false;
			}

			@Override
			public String describe(String[] values) {
				String items = "";
				for (String each : values) {
					items += each + ", ";
				}
				return "where expected [" + item + "], but contained [" + items + "].";
			}
		};
	}
}
