package org.exhibitj.operators;

import org.eclipse.swt.widgets.Text;
import org.exhibitj.operators.matchers.NamedControlMatcher;
import org.junit.Test;

public class TestTextField extends AbstractControlOperator<Text, TextOperator> {
	private static final String UNIQUE_WIDGET_NAME = "myName";

	@Override
	protected Class<Text> widgetType() {
		return Text.class;
	}
	
	@Test
	public void userEntersText() {
		TextOperator operator = createOperator();
		operator.click();
		operator.enterText("hello");
		operator.hasText(equalTo("hello"));
	}

	@SuppressWarnings("unchecked")
	@Override
	protected TextOperator createOperator() {
		manipulateWidget(new Runnable() {
			@Override
			public void run() {
				control.setData(NamedControlMatcher.DEFAULT_NAME, UNIQUE_WIDGET_NAME);
			}
		});
		return new TextOperator(shell, new NamedControlMatcher<Text>(UNIQUE_WIDGET_NAME));
	}

	@Test(timeout=5000)
	public void textVisibleToUser() throws Exception {
		TextOperator text = createOperator();
		
		text.hasText(equalTo(""));
	}

}
