import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

/**
 * HashTable Class
 * 
 * Linked Hashtable with a Java HashMap as a linked List.
 * Solves collisions with linked list hashing.
 * @author Wella
 *
 */
public class HashTable {

	HashMap<String, HashSet<String>> hash;
	
	/**
	 * Constructor Methods
	 */
	public HashTable() {
		this.hash = new HashMap <String, HashSet<String>>();

	}
	
	/**
	 * Inserts the key and input in the hashtable.
	 * Also checks if the input is the key and inserts the key as input.
	 * 
	 * @param key key of the hashtable
	 * @param input input, that should be inserted into the hashtable
	 */
	public void insert(String key, String input) {
		HashSet<String> keyLeft = containKey(key);
		if (keyLeft != null) {
			//Links ist ein key
			HashSet<String> inputLeft = containKey(input);
			if (inputLeft != null) {
				//Links ist auch der input --> beide hashtabellen verknpfen (keyLeft + inputLeft)
				if (inputLeft != keyLeft) {
					keyLeft.addAll(inputLeft);
					keyLeft.add(input);
					this.hash.remove(input);
					inputLeft.clear();
					inputLeft = null;
				}
				
			} else {
				HashSet<String> inputRight = containObject(input);
				if (inputRight != null) {
					//Links ist ein key, und rechts der input --> beide hashtabellen verknpfen (inputRight + keyLeft)
					if (inputRight != keyLeft) {
						String key2 = getKey(input);
						keyLeft.addAll(inputRight);
						keyLeft.add(key2);
						this.hash.remove(key2);
						inputRight.clear();
						inputRight = null;
					}
					
				} else {
					//Links ist ein key, und rechts kein input --> nur den input wert entsprechend schreiben
					keyLeft.add(input);
				}
			}
		} else {
			//Links ist kein key
			HashSet<String> inputLeft = containKey(input);
			if (inputLeft != null) {
				//Links ist kein key, aber input ist links
				HashSet<String> keyRight = containObject(key);
				if (keyRight != null) {
					//beide hashtabellen verknpfen (keyRight und inputLeft)
					if (keyRight != inputLeft) {
						String key2 = getKey(key);
						inputLeft.addAll(keyRight);
						inputLeft.add(key2);
						this.hash.remove(key2);
						keyRight.clear();
						keyRight = null;
					}
					
				} else {
					//Links ist kein key und rechts auch nicht, aber input ist links
					inputLeft.add(key);
				}
			} else {
				//Links ist kein key und input auch nicht
				HashSet<String> keyRight = containObject(key);
				if (keyRight != null) {
					//key ist rechts
					HashSet<String> inputRight = containObject(input);
					if (inputRight != null) {
						//key und input beide rechts --> beide Mengen verknpfen (keyRight + inputRight)
						if (inputRight != keyRight) {
							String key2 = getKey(input);
							keyRight.addAll(inputRight);
							
							keyRight.add(key2);
							this.hash.remove(key2);
							inputRight.clear();
							inputRight = null;
						}
						
					} else {
						//input der keyMenge hinzufgen
						keyRight.add(input);
					}
				} else {
					HashSet<String> inputRight = containObject(input);
					if (inputRight != null) {
						//input ist rechts --> Key der Menge hinzufgen
						inputRight.add(key);
					} else {
						//kein input und key ist irgendwo vorhanden --> komplett neuer eintrag
						HashSet<String> set = new HashSet<String>();
						this.hash.put(key, set);
						set.add(input);
					}
				}
			}
		}
	}
	
	/**
	 * Returns the Key for the corresponding input of the hashtable
	 * 
	 * @param input for which the key should be retrieved
	 * @return key of the corresponding input of the hashtable
	 */
	public String getKey(String input) {
		String key = "";
		boolean hit = false;
		Iterator<String> it = this.hash.keySet().iterator();
		while(it.hasNext() && !hit) {
			key = it.next();
			Iterator<String> it2 = this.hash.get(key).iterator();
			while(it2.hasNext() && !hit) {
				String entry = it2.next();
				if (entry.equalsIgnoreCase(input)) {
					hit = true;
				}
			}
		}
		
		return key;
	}
	
	/**
	 * Returns the HashSet of the Hashtable of the String s.
	 * 
	 * @param s key of the hashtable
	 * @return HashSet for the input key
	 */
	private HashSet<String> containKey(String s) {
		return this.hash.get(s);
	}
	
	/**
	 * Checks if the String s is in a hashSet of the hashtable.
	 * if yes, the corresponding HashSet will be returned, else null will be returned.
	 * 
	 * @param s checks if this String is in the hashtable
	 * @return the HashSet of the String
	 */
	private HashSet<String> containObject(String s) {
		HashSet<String> result = null;
		
		boolean hit = false;
		Iterator<String> it = this.hash.keySet().iterator();
		while(it.hasNext() && !hit) {
			String key = it.next();
			Iterator<String> it2 = this.hash.get(key).iterator();
			while(it2.hasNext() && !hit) {
				String entry = it2.next();
				if (entry.equalsIgnoreCase(s)) {
					result = this.hash.get(key);
					hit = true;
				}
			}
		}
		
		return result;
	}
	
	/**
	 * Returns the key of the hashSet in which the input is stored.
	 * 
	 * @param input String that should be checked
	 * @return Key of the input String
	 */
	public String contains(String input) {
		boolean hit = false;
		String result = null;
		Iterator<String> it = this.hash.keySet().iterator();
		while(it.hasNext() && !hit) {
			String key = it.next();
			Iterator<String> it2 = this.hash.get(key).iterator();
			while(it2.hasNext() && !hit) {
				String entry = it2.next();
				if (entry.equalsIgnoreCase(input)) {
					result = key;
					hit = true;
				}
			}
		}
		return result;
	}

	/**
	 * Prints the Hashtable in the console.
	 * @return
	 */
	public String print () {
		String result = "";
		String elem = "";
		Iterator<String> it1 = this.hash.keySet().iterator();
		while(it1.hasNext()) {
			elem = it1.next();
			result += "Key " + elem + " :";
			Iterator<String> it = this.hash.get(elem).iterator();
			String s = "";
			while (it.hasNext()) {
			  s = it.next();
			  result += " " + s + ",";
			} 
			result += "\n";
		} 
		return result;
	}
	
	
	/**
	 * Returns the Key for the corresponding input of the hashtable
	 * 
	 * @param input for which the key should be retrieved
	 * @return key of the corresponding input of the hashtable
	 */
	public LinkedList<String> getList(String input) {
		LinkedList<String> l = new LinkedList();
		Iterator<String> it2 = containKey(input).iterator();
		if (it2 == null) {
			//Wenn null, dann muss er hier drin sein
			it2 = containObject(input).iterator();
		}
		if (it2 != null) {
			while(it2.hasNext()) {
				l.add(it2.next());
			}
			String key = contains(input);
			if (key != null) {
				l.add(key);
			}
			
		}
		
		
		
		return l;
	}
	
	public int[] statistic() {
		int[] ret = new int[2];
		int sizeMap = 0;
		ret[0] = this.hash.size();
		Iterator<String> it1 = this.hash.keySet().iterator();
		while(it1.hasNext()) {
			HashSet<String> h = this.hash.get(it1.next());
			sizeMap = sizeMap + h.size();
		}
		ret[1] = sizeMap;
		return ret;
	}
}
