/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.client;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 *
 * @author rbs
 */
public class InputSender extends Thread {
    private final String fmsOrPoc;
    private final String fms1;
    private final String fms2;
    private final String fms3;
    private final String ip;


    
    public InputSender(String fmsOrPoc, String fms1, String fms2, String fms3, String ip){
        this.fmsOrPoc = fmsOrPoc;
        this.fms1 = fms1;
        this.fms2 = fms2;
        this.fms3 = fms3;
        this.ip = ip;
    
    }

    @Override
    public void run() {
        
        Socket client;
        try {
            client = new Socket(ip, 15112);
            DataOutputStream outToServer = new DataOutputStream(client.getOutputStream());
            outToServer.writeBytes(fmsOrPoc + "\n"); //FMS or POCSAG
            outToServer.writeBytes(fms1 + "\n");
            outToServer.writeBytes(fms2 + "\n");
            outToServer.writeBytes(fms3 + "\n");
            client.close();
            System.out.println("Connection to " + ip + " was sucessful.");
        } catch (UnknownHostException ex) {
            System.out.println("Connection to " + ip + " was unsucessful: \n" + ex);
        } catch (IOException ex) {
            System.out.println("Connection to " + ip + " was unsucessful: \n" + ex);
        }
        
        

    }
    
    
    
}
