/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server;

import fmsactionserver.server.check.ActionChecker;
import fmsactionserver.server.check.ActionState;
import fmsactionserver.server.logger.InputLogger;
import fmsactionserver.server.elements.Input;
import fmsactionserver.server.settings.actions.data.InputType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/**
 *
 * @author rbs
 */
public class InputServer extends Thread{
    private final FMSActionServer fmsServer;
    private final InputLogger logger;

    public InputServer(FMSActionServer fmsServer, InputLogger logger) throws IOException {
        
        this.fmsServer = fmsServer;
        this.logger = logger;
        
    }

    @Override
    public void run() {
        try {
            ServerSocket server = new ServerSocket(15112);
            
            while(true)
            {
                
                Socket client = server.accept();
                BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                
                String inputTypeString = reader.readLine();
                InputType type;
                
                if (inputTypeString.equals("FMS"))
                    type = InputType.FMS;
                else
                    type = InputType.POCSAG;
                
                String fms1 = reader.readLine();
                String fms2 = reader.readLine();
                String fms3 = reader.readLine();
                
                System.out.println("Received: " + fms1 + " " + fms2 + " " + fms3);
                
                
                ActionChecker checker = new ActionChecker(fmsServer.getSettings());
                
                Input input = new Input(type, fms1, fms2, fms3, ActionState.NO_ACTION); //only temporary with no action
                ActionState action = checker.startActionWhenAvailable(input);
                
                input = new Input(type, fms1, fms2, fms3, action);
                logger.addInput(input);
                
                
                
            }
        } catch(BindException ex){
            Logger.getLogger(InputServer.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, "Programm wird bereits ausgeführt. Diese Instanz wird beendet.");
            System.exit(-2);
        }
        catch (IOException ex) {
            Logger.getLogger(InputServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    
    
    
    
}
