/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.inetclient;

import fmsactionserver.server.check.ActionState;
import fmsactionserver.server.elements.Input;
import fmsactionserver.server.logger.InputLogger;
import fmsactionserver.server.settings.actions.data.InputType;
import fmsactionserver.server.settings.input.InputSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/**
 *
 * @author rbs
 */
public class InetRefresher extends TimerTask{
    private final InputSettings settings;
    
    private final InputLogger logger;

    public InetRefresher(InputSettings settings, InputLogger logger) {
        System.out.println("InetRefresher init");
        this.settings = settings;
        
        this.logger = logger;
    }

    @Override
    public void run() {
        Date last_update = logger.getLast_update();
        
        try {
            Socket client = new Socket(settings.getHost(), 11202);
            PrintWriter writer = new PrintWriter(client.getOutputStream(), true);
            writer.println("1.0");
            writer.println("GET_SINCE_DATE#" + last_update.getTime());
            
            BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
            
            String readLine = "";
            while (!readLine.equals("200 END FMS DATA"))
            {
                readLine = reader.readLine();
                System.out.println(readLine);
                if (!readLine.startsWith("200"))
                {
                    String[] split = readLine.split("#");
                    Date date = new Date(Long.parseLong(split[0]));
                    logger.addInput(new Input(InputType.FMS, date, split[1], 
                            split[2], split[3], ActionState.SUCESSFULL));
                }
            }
            
            while (!readLine.equals("200 CONNECTION CLOSE"))
            {
                readLine = reader.readLine();
                System.out.println(readLine);
                if (!readLine.startsWith("200"))
                {
                    String[] split = readLine.split("#");
                    Date date = new Date(Long.parseLong(split[0]));
                    logger.addInput(new Input(InputType.POCSAG, date, split[1], 
                            split[2], split[3], ActionState.SUCESSFULL));
                }
            }
        } catch (UnknownHostException ex) {
            JOptionPane.showMessageDialog(null, "Unbekannter Host. Ist die Internet-/Netzwekverbindung aktiv?");
            Logger.getLogger(FMSClient.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(FMSClient.class.getName()).log(Level.SEVERE, null, ex);
        }
        
    }
    
    
    
}
