/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.logger;

import fmsactionserver.server.InputServer;
import fmsactionserver.server.elements.Input;
import fmsactionserver.server.elements.SpecialInput;
import fmsactionserver.server.logger.logevent.InputEvent;
import fmsactionserver.server.logger.logevent.InputEventMulticaster;
import fmsactionserver.server.logger.logevent.InputListener;
import fmsactionserver.server.settings.actions.data.InputType;
import java.util.ArrayList;
import java.util.Date;

/**
 *
 * @author rbs
 */
public class InputLogger {

    
    
    static final String FMSINPUTYPE = "FMS";
    static final String POCSAGINPUTYPE = "POCSAG";
    
    ArrayList<Input> inputs;
    
    ArrayList<SpecialInput> fmsInput;
    ArrayList<SpecialInput> pocsagInput;
    
    InputEventMulticaster multicaster = new InputEventMulticaster();

    Date last_update = new Date();
    
    public InputLogger() {
        inputs = new ArrayList<Input>();
        fmsInput = new ArrayList<SpecialInput>();
        pocsagInput = new ArrayList<SpecialInput>();
    }
    
    public void addInput(Input input)
    {
        last_update = new Date();
        inputs.add(input);
        
        multicaster.onEvent(new InputEvent(this, input));
        
        if (input.type == InputType.FMS)
            fmsInput.add(input.getSpecialInput());
        else if (input.type == InputType.POCSAG)
            pocsagInput.add(input.getSpecialInput());
    }
    
    public ArrayList<SpecialInput> getFMSInputs()
    {
        return fmsInput;
    }
    
    public ArrayList<SpecialInput> getPOCSAGInputs()
    {
        return pocsagInput;
    }
    
    public void addInputListener(InputListener listener)
    {
        multicaster.add(listener);
    }

    public Date getLast_update() {
        return last_update;
    }
    
    
    
}
