/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.settings.actions;

import fmsactionserver.server.settings.actions.data.ActionSetting;
import fmsactionserver.server.settings.actions.data.ActionSettingsCollector;
import fmsactionserver.server.settings.actions.elements.ActionTablePanel;
import fmsactionserver.server.settings.actions.elements.InputPanel;
import fmsactionserver.server.settings.actions.elements.MainControllPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JFrame;

/**
 *
 * @author rbs
 */
public class SettingsFrame extends JFrame{

    ActionTablePanel tablePanel;
    InputPanel inputPanel;
    
    MainControllPanel controllPanel;
    
    
    public SettingsFrame(String directory, ActionSettingsCollector settings) {
        
        setMinimumSize(new Dimension(600, 650));
        setPreferredSize(new Dimension(600, 650));
        setLayout(new BorderLayout());
        
        tablePanel = new ActionTablePanel();
        inputPanel = new InputPanel();
        controllPanel = new MainControllPanel(directory, tablePanel, inputPanel, this, settings);
        
        for (ActionSetting setting : settings.getSettings()) {
            tablePanel.addRow(setting);
        }
        add(tablePanel, BorderLayout.NORTH);
        add(inputPanel, BorderLayout.CENTER);
        add(controllPanel, BorderLayout.SOUTH);
        
        setVisible(true);
    }
    
}
