/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package fmsactionserver.server.settings.actions.elements;

import fmsactionserver.server.settings.actions.data.InputType;
import fmsactionserver.server.settings.actions.data.ActionSetting;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

/**
 *
 * @author rbs
 */
public class ActionTablePanel extends JPanel{

    private JTable table;
    private DefaultTableModel dtm;
    
    public ActionTablePanel() {
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        
        String names[] = {"Typ", "RIC/FMS-Kennung", "Aktion", "Sound"};
         dtm = new DefaultTableModel(names, 0);
        
        table = new JTable(dtm);
        
        add(new JScrollPane(table), BorderLayout.CENTER);
    }
    
    public void addRow(ActionSetting setting)
    {
        String row_data[] = {setting.type.toString(), setting.ricOrFms, setting.action, setting.sound};
        dtm.addRow(row_data);
    }
    
    public void delSelectedRow()
    {
        int selectedRow = table.getSelectedRow();
        dtm.removeRow(selectedRow);
    }
    
    public ActionSetting getSettingFromSelectedRow()
    {
        int selectedRow = table.getSelectedRow();
        
        ActionSetting setting;
        if (dtm.getValueAt(selectedRow, 0).equals("FMS"))
            setting = new ActionSetting(InputType.FMS, (String) dtm.getValueAt(selectedRow, 1),
                (String) dtm.getValueAt(selectedRow, 2), (String) dtm.getValueAt(selectedRow, 3));
        else
            setting = new ActionSetting(InputType.POCSAG, (String) dtm.getValueAt(selectedRow, 1),
                (String) dtm.getValueAt(selectedRow, 2), (String) dtm.getValueAt(selectedRow, 3));
        
        return setting;
    }
    
}
