package edu.vub.at.kryo;

import edu.vub.at.objects.ATObject;

public class ThreadATKryoContext {
	
	private static ThreadLocal atKryo = new ThreadLocal(){
        @Override
        protected ATKryo initialValue() {
      	try {
      		return new ATKryo();
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			}
			return null;
        }
    };
    
    private static ThreadLocal lastMessageSerialized = new ThreadLocal(){
        @Override
        protected byte[] initialValue() {
			return null;
        }
    };
    
    private static ThreadLocal lastMessage = new ThreadLocal(){
        @Override
        protected ATObject initialValue() {
        	return null;
        }
    };
    
    public static ATKryo get() {
        return (ATKryo) atKryo.get();
    }
    
    public static byte[] getLastMessageSerialized() {
        return (byte[]) lastMessageSerialized.get();
    }
    
    public static ATObject getLastMessage() {
        return (ATObject) lastMessage.get();
    }
    
    
    public static void reset() {
    	atKryo.remove();
    	try {
    		atKryo.set(new ATKryo());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
    }
    
    public static void resetLastMessageSerialized() {
    	lastMessageSerialized.remove();
    }
    
    public static void resetLastMessage() {
    	lastMessage.remove();
    }

	public static void set(ATKryo value) {
		atKryo.set(value);
	}
	
	public static void setLastMessageSerialized(byte[] value){
		lastMessageSerialized.set(value);
	}
	
	public static void setLastMessage(ATObject value){
		lastMessage.set(value);
	}
	
}
