package benchmarks;
//TODO Doet moeilijk!
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;

import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.objects.natives.NATText;

public class HessianLib extends TestClasses implements TestMethods{

	public HessianLib() throws InterpreterException, IOException {
		super();
	}

	@Override
	public byte[] serialize(Object o) throws IOException {
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		Hessian2Output out = new Hessian2Output(bos);
		out.startMessage();
		out.writeObject(o);
		out.completeMessage();
		out.close();
		return bos.toByteArray();
	}


	@Override
	public Object deserialize(byte[] b, Class c) throws IOException,
			ClassNotFoundException {
		ByteArrayInputStream bin = new ByteArrayInputStream(b);
		Hessian2Input in = new Hessian2Input(bin);
		in.startMessage();	
		Object o = in.readStreamingObject();
		in.completeMessage();
		in.close();	
		bin.close();
		return o;
	}

	@Override
	public Object copy(Object o) throws IOException, ClassNotFoundException {
		return deserialize(serialize(o), o.getClass());
	}
	
}
