package tests;

import java.io.File;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

import edu.vub.at.exceptions.InterpreterException;

public class CaliperTests extends TestCase {

	protected static DefaultCategoryDataset dataset = new DefaultCategoryDataset();

	public static Test suite() throws InterpreterException, IOException {

		TestSuite suite = new TestSuite("All Caliper related tests");
		// $JUnit-BEGIN$
		suite.addTestSuite(NativeJavaTest.class);
		suite.addTestSuite(KryoLibTest.class);
		suite.addTestSuite(GSonLibTest.class);
		suite.addTestSuite(JacksonLibTest.class);
		suite.addTestSuite(SmartJSONLibTest.class);
		suite.addTestSuite(ProtostuffLibTest.class);
		suite.addTestSuite(CastorLibTest.class);
		suite.addTestSuite(FlexJSONLibTest.class);
		suite.addTestSuite(JSONIOLibTest.class);
		suite.addTestSuite(XStreamLibTest.class);
		suite.addTestSuite(XStreamDomDriverLibTest.class);
		suite.addTestSuite(XStreamStaxDriverLibTest.class);
		return new SizeTests(suite);
	}
}
