package tests;


import java.io.IOException;

import benchmarks.KryoLib;
import benchmarks.TestClasses;
import benchmarks.TestMethods;
import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.objects.ATTable;
import edu.vub.at.objects.natives.NATTable;
import edu.vub.at.objects.natives.OBJLexicalRoot;

public class KryoLibTest extends Tests{

	protected void setUp() throws InterpreterException, IOException{
		new TestClasses();
		currentLib = (TestMethods) new KryoLib();
	}
	
	public void testEmpty() throws ClassNotFoundException, IOException{
		ATTable x = (ATTable) currentLib.copy(NATTable.EMPTY);
		assertSame(NATTable.EMPTY, x);
	}
	
	public void testInstance() throws ClassNotFoundException, IOException{
		OBJLexicalRoot x = (OBJLexicalRoot) currentLib.copy(OBJLexicalRoot._INSTANCE_);
		assertSame(OBJLexicalRoot._INSTANCE_, x);
	}
	

	public void testSize() throws IOException{		
		CaliperTests.dataset.addValue(currentLib.serialize(TestClasses.boeTXT).length, "Serialized NATText", currentLib.getClass().getName().substring(11));
		System.out.println(currentLib.serialize(TestClasses.boeTXT).length);
	}
	
}
