package gaery.utils;


import java.io.*;

public class DirFilterWatcher implements FileFilter {
  private String[] filters;

  public DirFilterWatcher() {
    this.filters = new String[0];
  }

  public DirFilterWatcher(String[] filter) {
    this.filters = filter;
  }
  
  public boolean accept(File file) {
    if (filters ==null || filters.length == 0) {
      return true;
    }
    
    for (String filter : filters) {
    	if (file.getName().endsWith(filter)) {
    		return true;
    	}
    }
    
    return false;
  }
}