package org.masterview.user.client.data;

import java.util.List;

public interface DataSource {
    public int getPageCount();

    public void refreshDisplayData();

    public List getInitialData();

    public void setInitialData(List data);

    public List getDisplayData();

    public void setDisplayData(List displayData);

    public void setPropertyMapper(PropertyMapper propertyMapper);

    public PropertyMapper getPropertyMapper();

    public void clearData();

    public String getPropertyToSort();

    public void setPropertyToSort(String propertyToSort);

    public String getSortType();

    public void setSortType(String sortType);

    public void addDataSourceListener(DataSourceListener dataSourceListener);

    public void removeDataSourceListener(DataSourceListener dataSourceListener);

    public void addFilter(Filter filter);

    public void removeFilter(Filter filter);

    public void clearFilters(Filter filter);

    public void clearFiltersByProperty(String propertyName);

    public int getCurrentPageNumber();

    public void setCurrentPageNumber(int currentPageNumber);

    public int getPageSize();

    public void setPageSize(int pageSize);

    public void adjustCurrentPage();

    public void toPreviousPage();

    public void toNextPage();

    public void toFirstPage();

    public void toLastPage();        

    public boolean isEmpty();
}

