package org.masterview.user.client.ui;

import org.masterview.user.client.data.PropertyMapper;
import org.masterview.user.client.data.DataSource;

import java.util.List;

public interface GridRenderer {
    public Grid getGrid();
    public void setGrid(Grid grid);

    public DataSource getDataSource();
    public void setDataSource(DataSource dataSource);

    public String getGridStyle();
    public String getHeaderStyle();
    public String getFilterStyle();
    public String getRowStyle(int row);
    public String getRowHighlightStyle();
    public String getHeaderCellStyle();
    public String getRowCellStyle();
    public String getCellAscendingSortingStyle();
    public String getCellDescendingSortingStyle();

    public void highlightRow(int rowNumber);
    public void cancelRowHighlighting(int rowNumber);

    public void renderHeader(List columns);
    public void renderFilters(List columns);
    public int renderItems(List columns, DataSource dataSource);
}