package org.masterview.user.client.ui;

import com.google.gwt.user.client.ui.Composite;
import org.masterview.user.client.data.PropertyMapper;
import org.masterview.user.client.data.DataSourceImpl;

import java.util.List;

public abstract class MasterView extends Composite {
    protected Grid grid;
    protected DataSourceImpl dataSource;
    protected Pager pager;

    public void setPropertyMapper(PropertyMapper propertyMapper) {
        dataSource.setPropertyMapper(propertyMapper);
    }

    public Pager getPager() {
        return pager;
    }

    public void setPager(Pager pager) {
        this.pager = pager;
    }

    public abstract PropertyMapper getPropertyMapper();

    public MasterView() {
        dataSource = new DataSourceImpl();        
        dataSource.setPropertyMapper(getPropertyMapper());

        grid = new Grid(dataSource);
        pager = new Pager(grid, dataSource);

        initWidget(pager);
    }

    public void setItems(List items) {
        dataSource.setInitialData(items);
    }

    public void appendColumn(Column column) {
        grid.appendColumn(column);
    }

    public void setFilteringEnabled(boolean filteringEnabled) {
        grid.setFilteringEnabled(filteringEnabled);
    }

    public void setPageSize(int pageSize) {
        dataSource.setPageSize(pageSize);
    }
}