package advanced;

import java.util.Set;

import com.google.common.collect.SetMultimap;

/**
 * A generic interface for what constitutes a dynamic.
 * @author Carl Pearson
 *
 * @param <VERTEXTYPE> the class used to represent vertices
 * @param <STATETYPE> the class used to represent states
 * @param <SYSTEMSTATETYPE> the class use to represent system states
 */
public interface Dynamic<VERTEXTYPE, STATETYPE extends Enum<STATETYPE>, SYSTEMSTATETYPE extends SupportState<VERTEXTYPE, STATETYPE>> {

	//TODO currently assumes only "ON" states are interesting
	public SetMultimap<STATETYPE,? extends Set<VERTEXTYPE>> precursors(VERTEXTYPE which);
	
	/**
	 * A set of the vertices that participate in this Dynamic.
	 * @return
	 */
	public Set<VERTEXTYPE> vertices();
	
	public SYSTEMSTATETYPE get(SYSTEMSTATETYPE from);
		
	public Iterable<SYSTEMSTATETYPE> unfixedSources();
	public Set<SYSTEMSTATETYPE> fixedSources();
	
	public int activity();
	
}
