package base;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;

/**
 * {@code Edge} represents the type of edge exists between two vertices.  All possible options are represented;
 * Some are mutually exclusive (e.g., {@link #TURN_ON} and {@link #TURN_OFF}), some can be represented in multiple
 * ways (e.g., {@link #DO_NOTHING}} == {@link #NOT_TURN_OFF}} and {@link #NOT_TURN_ON}).
 * <p>
 * Some immutable, static convenience collections are also included.
 * @author Carl A Pearson
 * @version 1
 */
public enum Edge {

	DO_NOTHING,
	TURN_OFF,
	TURN_ON,
	NOT_TURN_OFF,
	NOT_TURN_ON;
	
	/**
	 * The options for a fixed edge: none, inhibiting, activating.
	 */
	public static final ImmutableSet<Edge> fixed = Sets.immutableEnumSet(DO_NOTHING, TURN_OFF, TURN_ON);
	
	public static final ImmutableSet<Edge> turnOnOrNot = Sets.immutableEnumSet(DO_NOTHING, TURN_ON);
	public static final ImmutableSet<Edge> turnOffOrNot = Sets.immutableEnumSet(DO_NOTHING, TURN_OFF);
	
	public static final ImmutableList<Edge> all = ImmutableList.copyOf(Edge.values());
	
}
