package bittwiddled;

import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.SortedSet;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

public abstract class AbstractBeforeStates<T> {
	
	NavigableSet<T> beforeON;
	NavigableMap<T, T> beforeOFF;
	NavigableSet<T> requiredBeforeOFF;

	int activators = 0;
	int inhibitors = 0;
	int nonActivators = 0;
	int nonInhibitors = 0;
	
	AbstractBeforeStates(Iterable<T> beforeON, Iterable<T> beforeOFF) {
		this.beforeON = sourceSet();
		for (T term : beforeON) this.beforeON.add(term);
		
		this.beforeOFF = sourceMap();
		for (T term : beforeOFF) this.beforeOFF.put(term, term);
		
		this.requiredBeforeOFF = sourceSet();
	}
	
	NavigableSet<T> sourceSet() { return Sets.newTreeSet(comparator()); }
	NavigableMap<T,T> sourceMap() { return Maps.newTreeMap(comparator()); }
	
	abstract Comparator<T> comparator();
	
	NavigableSet<T> beforeON() { return beforeON; }		
	NavigableMap<T,T> beforeOFF() { return beforeOFF; }
	NavigableSet<T> requiredBeforeOFF() { return requiredBeforeOFF; }

	public SortedSet<T> reducedActivators() { return Collections.unmodifiableSortedSet(beforeON); }
	public SortedSet<T> requiredInhibitors() { return Collections.unmodifiableSortedSet(requiredBeforeOFF); }
	public SortedMap<T,T> mixedTerms() { return Collections.unmodifiableSortedMap(beforeOFF); }
		
}